<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsToMany('App\Models\User', 'company_associate_users', 'company_id', 'user_id');
    }

    public function job()
    {
        return $this->hasMany('App\Models\Job', 'company_id');
    }

    public function events()
    {
        return $this->hasMany('App\Models\Event', 'hosted_by');
    }

}